VERSION 5.00
Begin VB.Form Form1 
   BackColor       =   &H80000013&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Power Adj"
   ClientHeight    =   7245
   ClientLeft      =   1020
   ClientTop       =   1785
   ClientWidth     =   10455
   ForeColor       =   &H00000000&
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7245
   ScaleWidth      =   10455
   Begin VB.TextBox txtLevelAdj 
      Height          =   285
      Left            =   6000
      TabIndex        =   19
      Text            =   "0"
      Top             =   840
      Width           =   735
   End
   Begin VB.PictureBox Picture1 
      ForeColor       =   &H000000FF&
      Height          =   4335
      Left            =   5280
      ScaleHeight     =   10
      ScaleMode       =   0  'User
      ScaleWidth      =   20
      TabIndex        =   14
      Top             =   1920
      Width           =   4695
   End
   Begin VB.CommandButton Command1 
      Caption         =   "CH Power"
      Height          =   495
      Index           =   1
      Left            =   240
      TabIndex        =   13
      Top             =   720
      Width           =   1455
   End
   Begin VB.CheckBox Check2 
      Caption         =   "SG Access"
      Height          =   375
      Left            =   5520
      TabIndex        =   12
      Top             =   240
      Width           =   1215
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Averaging"
      Height          =   375
      Left            =   8160
      TabIndex        =   11
      Top             =   240
      Width           =   1215
   End
   Begin VB.TextBox txtROfs 
      Height          =   285
      Left            =   2820
      TabIndex        =   6
      Text            =   "0"
      Top             =   1035
      Width           =   975
   End
   Begin VB.TextBox txtRef 
      Height          =   270
      Left            =   2820
      TabIndex        =   5
      Text            =   "24"
      Top             =   600
      Width           =   975
   End
   Begin VB.TextBox txtCarr 
      Height          =   270
      Left            =   2820
      TabIndex        =   2
      Text            =   "2000"
      Top             =   180
      Width           =   975
   End
   Begin VB.TextBox txtRslt 
      BeginProperty Font 
         Name            =   "lr SVbN"
         Size            =   9
         Charset         =   128
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   5595
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Top             =   1440
      Width           =   4155
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Zero Span"
      Height          =   495
      Index           =   0
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label Label8 
      Caption         =   " Linearity Graph  (Data Difference)"
      Height          =   255
      Left            =   6240
      TabIndex        =   22
      Top             =   1560
      Width           =   2535
   End
   Begin VB.Line Line2 
      X1              =   7680
      X2              =   7680
      Y1              =   240
      Y2              =   1200
   End
   Begin VB.Line Line1 
      X1              =   4680
      X2              =   4680
      Y1              =   240
      Y2              =   1200
   End
   Begin VB.Label Label7 
      Caption         =   " dB"
      Height          =   255
      Left            =   6840
      TabIndex        =   21
      Top             =   840
      Width           =   375
   End
   Begin VB.Label Label6 
      Caption         =   " Level Offset"
      Height          =   255
      Left            =   4920
      TabIndex        =   20
      Top             =   840
      Width           =   975
   End
   Begin VB.Label Label5 
      Caption         =   "  Measurement Count  (-4dB step)  --->"
      Height          =   255
      Left            =   6240
      TabIndex        =   18
      Top             =   6480
      Width           =   2775
   End
   Begin VB.Label Label4 
      Caption         =   " -5 dB"
      Height          =   255
      Left            =   4680
      TabIndex        =   17
      Top             =   6000
      Width           =   495
   End
   Begin VB.Label Label3 
      Caption         =   " +5 dB"
      Height          =   255
      Left            =   4680
      TabIndex        =   16
      Top             =   1920
      Width           =   495
   End
   Begin VB.Label Label2 
      Caption         =   "  0"
      Height          =   255
      Left            =   4800
      TabIndex        =   15
      Top             =   3960
      Width           =   375
   End
   Begin VB.Label Label1 
      Caption         =   "dB"
      Height          =   195
      Index           =   5
      Left            =   3900
      TabIndex        =   10
      Top             =   1080
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "dBm"
      Height          =   195
      Index           =   4
      Left            =   3900
      TabIndex        =   9
      Top             =   660
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "Ext. ATT."
      Height          =   195
      Index           =   3
      Left            =   1920
      TabIndex        =   8
      Top             =   1080
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Input Lvl."
      Height          =   195
      Index           =   2
      Left            =   1920
      TabIndex        =   7
      Top             =   660
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Carrier:"
      Height          =   195
      Index           =   1
      Left            =   1920
      TabIndex        =   4
      Top             =   240
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "MHz"
      Height          =   195
      Index           =   0
      Left            =   3900
      TabIndex        =   3
      Top             =   240
      Width           =   615
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub Command1_Click(Index As Integer)

Dim Carr As Double
Dim Ref As Integer
Dim Ofs As Double
Dim Ladj As Double

Carr = Val(txtCarr) * 1000000#
Ref = Val(txtRef)
Ofs = Val(txtROfs)
Ladj = Val(txtLevelAdj)


Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
Call ibdev(0, 6, 0, 13, 1, 0, sg)   'GPIB Addr=6, Time out=10sec

Call ibwrt(ud, "SCRF ON")           'Screen ON/OFF

Select Case Index

  Case 0
  
    Call MeasChPow(Carr, Ref, Ofs, Ladj)      'ABS Power Measurement
    
    Call MeasZeropw(Carr, Ref, Ofs, Ladj)     'Level Adjustment Routine
    
    Call Dataline
    
  Case 1
  
    Call MeasAllch(Carr, Ref, Ofs, Ladj)      'Channel Power Measurement Mode
    
    Call Dataline
    
  Case Else
  
End Select

Call ibonl(ud, 0)                   'GPIB device 
Call ibonl(0, 0)                    'GPIB board 


End Sub

Sub MeasZeropw(measF As Double, measRef As Integer, measOfs As Double, Ladj As Double)
Dim Power As Double
Dim Tstart As Double
Dim Tstop As Double
Dim Setflag1 As Integer
Dim Setflag2 As Integer
Dim Mloop As Integer

    txtRslt.SelText = vbCrLf & "Average Power (Zero Span) Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "HS OFF; AA")                    'PreAmp Off, ATT Auto
    Call ibwrt(ud, "RB 3MZ; VB 3MZ")                'RBW 1MHz, VBW 1MHz
    Call ibwrt(ud, "SW 20MS")                       'SWEEP Time 20 or 100ms or ...
    Call ibwrt(ud, "SP 0HZ")                        'Span Zero
    
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    
    Call ibwrt(ud, "RO OFF")                        'Level Offset OFF
    Call RefLvlSet(measRef)                         'Reference Level Set

    Call ibwrt(ud, "PWAVGON")                       'AVG Power ON
    
    'txtRslt.SelText = "(Average mode ON)..." & vbCrLf
    'txtRslt.SelText = "(Average mode OFF)..." & vbCrLf
    
    Setflag1 = 0
    Setflag2 = 0
    DataCount = 0
    
    Tstart = Timer
    
    For Mloop = measRef To -56 Step -4              '24 to -56 ; 21 points
                                                    'Min Level=-56 (or you can change it)
        If Check2.value = 1 Then                    'SG seeting ?
        
            If Mloop > 20 Then Call ibwrt(ud, "RL 40DB")
            If Mloop <= 20 And Mloop > 10 Then Call ibwrt(ud, "RL 30DB")
            If Mloop <= 10 And Mloop > 0 Then Call ibwrt(ud, "RL 20DB")
            If Mloop <= 0 And Mloop > -10 Then Call ibwrt(ud, "RL 10DB")
            If Mloop <= -10 And Mloop > -57 Then
                If Setflag1 = 0 Then
                   Setflag1 = 1
                   Call ibwrt(ud, "RL 0DB")
                End If
            End If
            If Mloop <= -57 Then
                If Setflag2 = 0 Then
                    Setflag2 = 1
                    Call ibwrt(ud, "AT 10DB; HS ON")        'ATT Manual & PreAmp ON
                    Call ibwrt(ud, "RL -20DB")
                    Sleep 100                               'Wait PreAmp setting time
                End If
            End If
         
            Call ibwrt(sg, "SOUR:POW " & Format(Mloop))     '***** SG setup *****
            Sleep 30                                        'Wait SG setting time

        End If
        
        Call GetZeroPower(Power)                            'Measuremet
        Power = Power + measOfs + Ladj                      '+ Offset Level
        
        If Check2.value = 1 Then
            PowerData(DataCount) = Power - Mloop - measOfs      'Difference data save
            DataCount = DataCount + 1
        Else
            PowerData(DataCount) = Power - measRef - measOfs    'Difference data save
            DataCount = DataCount + 1                           'NO SG
        End If
            
        'ʕ\
        txtRslt.SelText = Mloop & ": AVG Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    Next Mloop
    
    Tstop = Timer
    txtRslt.SelText = vbCrLf & "Time = " & Format(Tstop - Tstart, "###0.000") & "sec" & vbCrLf
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "HS OFF; AA")                    'PreAmp Off, ATT Auto
    Call ibwrt(ud, "CONTS")                         'Sweep continue for AVG mode OFF


End Sub

Sub GetZeroPower(Power As Double)
Dim sBuff As String * 50
    
    If Check1.value = 0 Then                        'AverageȂꍇ = 1
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                            'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWAVGTM 10")                    'AVG POW/ AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait AVG end
        Call ibwrt(ud, "SI")                            'Sweep Stop
    End If
    
    Call ibwrt(ud, "PWAVG?")                        'GET AVG data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET AVG data
    Power = sBuff

End Sub

Sub MeasChPow(measF As Double, measRef As Integer, measOfs As Double, Ladj As Double)
Dim Power As Double
    
    txtRslt.SelText = vbCrLf & "Channel Power Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "HS OFF; AA")                    'PreAmp Off, ATT Auto
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")                'RBW 1MHz, VBW 1MHz
    Call ibwrt(ud, "SW 100MS")                      'Sweep 100ms or Auto, 50...
    Call ibwrt(ud, "SP 10e6HZ")                     'Span 10MHz

    Call ibwrt(ud, "CF " & Format(measF) & "HZ")           'Center frequency

    Call ibwrt(ud, "RO OFF")                               'Level Offset OFF
    Call RefLvlSet(measRef)                                'Reference Level Set
                
    If Check2.value = 1 Then
        Call ibwrt(sg, "SOUR:POW " & Format(measRef))      'SG Output Level setup
        Sleep 30                                           'Wait SG setting time
    End If
            
    Call ibwrt(ud, "WLX " & Format(measF) & "HZ")          'Ch Center
    Call ibwrt(ud, "WDX " & Format(3840000#) & "HZ")       'Ch Span
    Call ibwrt(ud, "PWCHON")                               'Ch Pow ON
    
    Call GetChPower(Power)                                 'Measurement
    Power = Power + measOfs + Ladj                         '+ Offset Level
    
    'ʕ\
    txtRslt.SelText = "CH Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "HS OFF; AA")                    'PreAmp Off, ATT Auto

End Sub

Sub GetChPower(Power As Double)
Dim sBuff As String * 50

    If Check1.value = 0 Then                        'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                            'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWCHTM 10")                     'CH Power AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait AVG end
        Call ibwrt(ud, "SI")                            'Sweep Stop
    End If
    
    Call ibwrt(ud, "PWCH?")                         'GET POW data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET POW data
    Power = sBuff

End Sub

Sub MeasAllch(measF As Double, measRef As Integer, measOfs As Double, Ladj As Double)
Dim Power As Double
Dim Setflag1 As Integer
Dim Setflag2 As Integer
Dim Mloop As Integer
Dim Tstart As Double
Dim Tstop As Double

    txtRslt.SelText = vbCrLf & "Channel Power Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "HS OFF; AA")                    'PreAmp Off, ATT Auto
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")                'RBW 1MHz, VBW 1MHz
    Call ibwrt(ud, "SW 100ms")                      'Sweep Auto or 50ms or ...
    Call ibwrt(ud, "SP 10e6HZ")                     'Span 10MHz

    Call ibwrt(ud, "CF " & Format(measF) & "HZ")           'Center frequency

    Call ibwrt(ud, "RO OFF")                               'Level Offset OFF
    Call RefLvlSet(measRef)                                'Reference Level Set
    
    If Check2.value = 1 Then
        Call ibwrt(sg, "SOUR:POW " & Format(measRef))      'SG Output Level setup
        Sleep 30                                           'Wait SG setting time
    End If
            
    Call ibwrt(ud, "WLX " & Format(measF) & "HZ")          'Ch Center
    Call ibwrt(ud, "WDX " & Format(3840000#) & "HZ")       'Ch Span
    Call ibwrt(ud, "PWCHON")                               'Ch Pow ON
        
    Setflag1 = 0
    Setflag2 = 0
    DataCount = 0
    
    Tstart = Timer
    
    For Mloop = measRef To -56 Step -4                  '24 to -56 ; 21 points
                                                        'Min Level=-56 (or you can change it)
        If Check2.value = 1 Then                        'SG setting ?
               
            If Mloop > 20 Then Call ibwrt(ud, "RL 40DB")
            If Mloop <= 20 And Mloop > 10 Then Call ibwrt(ud, "RL 30DB")
            If Mloop <= 10 And Mloop > 0 Then Call ibwrt(ud, "RL 20DB")
            If Mloop <= 0 And Mloop > -10 Then Call ibwrt(ud, "RL 10DB")
            If Mloop <= -10 And Mloop > -57 Then
                If Setflag1 = 0 Then
                   Setflag1 = 1
                   Call ibwrt(ud, "RL 0DB")
                End If
            End If
            If Mloop <= -57 Then
                If Setflag2 = 0 Then
                    Setflag2 = 1
                    Call ibwrt(ud, "AT 10DB; HS ON")        'ATT Manual & PreAmp ON
                    Call ibwrt(ud, "RL -20DB")
                    Sleep 100                               'Wait PreAmp setting time
                End If
            End If
        
            Call ibwrt(sg, "SOUR:POW " & Format(Mloop))     '***** SG setup *****
            Sleep 30                                        'Wait SG setting time
            
        End If
        
        Call GetChPower(Power)                              'Measurement
        Power = Power + measOfs + Ladj                      '+ Offset Level
        
        If Check2.value = 1 Then
            PowerData(DataCount) = Power - Mloop - measOfs      'Difference data save
            DataCount = DataCount + 1
        Else
            PowerData(DataCount) = Power - measRef - measOfs    'Difference data save
            DataCount = DataCount + 1                           'NO SG
        End If
        
        'ʕ\
        txtRslt.SelText = Mloop & ": CH Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    Next Mloop
        
        
    Tstop = Timer
    txtRslt.SelText = vbCrLf & "Time = " & Format(Tstop - Tstart, "###0.000") & "sec" & vbCrLf
    
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "HS OFF; AA")                    'PreAmp Off, ATT Auto
    Call ibwrt(ud, "CONTS")                         'Sweep continue for AVG mode OFF

End Sub

Sub RefLvlSet(InputP As Integer)

    If InputP > 20 Then Call ibwrt(ud, "RL 40DB")  'Reference Level
    If InputP <= 20 And InputP > 10 Then Call ibwrt(ud, "RL 30DB")
    If InputP <= 10 And InputP > 0 Then Call ibwrt(ud, "RL 20DB")
    If InputP <= 0 And InputP > -10 Then Call ibwrt(ud, "RL 10DB")
    If InputP <= -10 And InputP > -57 Then Call ibwrt(ud, "RL 0DB")
    If InputP <= -57 Then
        Call ibwrt(ud, "AT 10DB; HS ON")           'ATT Manual & PreAmp ON
        Call ibwrt(ud, "RL -20DB")
        Sleep 100                                  'Wait PreAmp setting time
    End If

End Sub


Private Sub Dataline()
Dim i As Integer


   AutoRedraw = False
   Picture1.Cls

   AutoRedraw = True

   For i = 0 To 10                                      'Range (0,0) (10,20)
       Picture1.Line (0, i)-(20, i), RGB(0, 0, 200)     'H Line
   Next i

   For i = 0 To 20
       Picture1.Line (i, 0)-(i, 10), RGB(0, 0, 200)     'V Line
   Next i

   Picture1.DrawWidth = 2
   
   Picture1.Line (0, 5)-(20, 5), RGB(0, 0, 200)         'Center Line
   
   Picture1.DrawWidth = 3
   
   Picture1.PSet (0, 5 - PowerData(0))                  'Point1 & Offset data = 5

   For i = 1 To DataCount - 1                           'Point2 to final point
        Picture1.Line -(i, 5 - PowerData(i))
   Next i

   Picture1.DrawWidth = 1


   AutoRedraw = False

End Sub

